 // Function to apply the theme
    function applyTheme(theme) {
      document.body.className = theme;
    }

    // Check sessionStorage for saved preference
    const savedTheme = sessionStorage.getItem('theme');
    if (savedTheme) {
      applyTheme(savedTheme);
    } else {
      // Default to light mode if no preference is saved
      applyTheme('light-mode');
    }

    // Toggle button functionality
    document.getElementById('theme-toggle').addEventListener('click', () => {
      const currentTheme = document.body.className;
      const newTheme = currentTheme === 'light-mode' ? 'dark-mode' : 'light-mode';

      // Apply and save the new theme
      applyTheme(newTheme);
      sessionStorage.setItem('theme', newTheme);
    });